unit UnitMm4;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, AXmsCtrl_TLB, StdCtrls, ShellAPI;

type
  TFormMm4 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    CheckBoxAuth: TCheckBox;
    EditHost: TEdit;
    EditPort: TEdit;
    EditAccount: TEdit;
    EditPassword: TEdit;
    EditDomain: TEdit;
    GroupBox3: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    ButtonSend: TButton;
    EditTo: TEdit;
    EditSubject: TEdit;
    EditBody: TMemo;
    EditImage: TEdit;
    ButtonBrowse: TButton;
    GroupBox4: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    EditResult: TEdit;
    EditResponse: TEdit;
    EditLogfile: TEdit;
    ButtonView: TButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ButtonSaveCfg: TButton;
    ButtonLoadCfg: TButton;
    procedure ButtonSaveCfgClick(Sender: TObject);
    procedure ButtonLoadCfgClick(Sender: TObject);
    procedure ButtonViewClick(Sender: TObject);
    procedure ButtonSendClick(Sender: TObject);
    procedure ButtonBrowseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    function GetResult : Integer;
    function GetTempDirectory: string;
    
  private
    objConnection : IMmsProtocolMm4;
    objMessage    : IMmsMessage;
    objSlide      : IMmsSlide;
    objConstants  : IMmsConstants;
  public
    { Public declarations }
  end;

var
  FormMm4: TFormMm4;

implementation

{$R *.dfm}

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm4.FormCreate(Sender: TObject);
var i : Integer;
begin
  objConnection    := TMmsProtocolMm4.Create(Application).DefaultInterface;
  objMessage       := TMmsMessage.Create(Application).DefaultInterface;
  objSlide         := TMmsSlide.Create(Application).DefaultInterface;
  objConstants     := TMmsConstants.Create(Application).DefaultInterface;

  GetTempDirectory ();
end;

{ //////////////////////////////////////////////////////////////////////////////// }

function TFormMm4.GetResult : Integer;
begin
  Result := objConnection.LastError;

  EditResponse.Text   := objConnection.ProviderResponse;
  EditResult.Text     := 'ERROR ' + IntToStr ( Result ) +  ' : ' + objConnection.GetErrorDescription( Result );
end;

{ //////////////////////////////////////////////////////////////////////////////// }

function TFormMm4.GetTempDirectory: string;
var Buffer: array[0..MAX_PATH] of Char;
begin
  GetTempPath(SizeOf(Buffer) - 1, Buffer);
  EditLogfile.Text := StrPas(Buffer) + 'MmsLog.txt';
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm4.ButtonBrowseClick(Sender: TObject);
begin
  OpenDialog.DefaultExt := '.jpg';
  OpenDialog.Filter     := 'Image Files|*.jpg';

  if OpenDialog.Execute = true Then begin
    EditImage.Text := OpenDialog.FileName;
  end;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm4.ButtonSendClick(Sender: TObject);
var vtVar : OleVariant;
begin
  ButtonSend.Enabled := False;
  Cursor := crHourGlass;

  { Set Connection Properties }
  objConnection.ProviderHost        := EditHost.Text;
  objConnection.ProviderPort        := StrToInt ( EditPort.Text );
  objConnection.ProviderDomain      := EditDomain.Text;

  if ( CheckBoxAuth.Checked ) then begin
    objConnection.ProviderAccount   := EditAccount.Text;
    objConnection.ProviderPassword  := EditPassword.Text;
  end;

  { Set Logfile }
  objConnection.LogFile             := EditLogfile.Text;

  { Set Message Properties }
  objMessage.AddRecipient           (EditTo.Text, objConstants.asMMS_RECIPIENT_TO);
  objMessage.Subject                := EditSubject.Text;

  { Create First Slide }
  vtVar := 0;

  objSlide.AddText(EditBody.Text);
  objSlide.AddAttachment (EditImage.Text, vtVar );

  vtVar := objSlide;
  objMessage.AddSlide(vtVar);

  vtVar := objMessage;

  { Send message }
  objConnection.Send(vtVar);
  GetResult ();

  ButtonSend.Enabled := True;
  Cursor := crDefault;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm4.ButtonViewClick(Sender: TObject);
var LogFile : PAnsiChar;
begin
  LogFile := StrNew(PChar(EditLogfile.Text));

  ShellExecute ( 0, 'open' , LogFile, '', '', SW_SHOW )
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm4.ButtonLoadCfgClick(Sender: TObject);
begin
  OpenDialog.DefaultExt := '.mm4';
  OpenDialog.Filter     := 'MMS Connection Files|*.mm4';

  if OpenDialog.Execute = true Then begin
    objConnection.ProviderLoadConfig (OpenDialog.FileName);

    if ( GetResult() = 0) then begin
      EditHost.Text                := objConnection.ProviderHost;
      EditPort.Text                := IntToStr ( objConnection.ProviderPort );
      EditAccount.Text             := objConnection.ProviderAccount;
      EditPassword.Text            := objConnection.ProviderPassword;
      EditDomain.Text              := objConnection.ProviderDomain;
    end;
  end;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

procedure TFormMm4.ButtonSaveCfgClick(Sender: TObject);
begin
  SaveDialog.DefaultExt := '.mm4';
  SaveDialog.Filter     := 'MMS Connection Files|*.mm4';

  if SaveDialog.Execute = true then begin
    objConnection.ProviderHost        := EditHost.Text;
    objConnection.ProviderPort        := StrToInt ( EditPort.Text );
    objConnection.ProviderDomain      := EditDomain.Text;

    if ( CheckBoxAuth.Checked ) then begin
      objConnection.ProviderAccount   := EditAccount.Text;
      objConnection.ProviderPassword  := EditPassword.Text;
    end;

    objConnection.ProviderSaveConfig(SaveDialog.FileName);

    GetResult ();
  end;
end;

{ //////////////////////////////////////////////////////////////////////////////// }

end.
